/**
 * \file: mlink_wfd_decoder_plugin.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * MLINK WiFi-Display Decoder plug-in
 *
 * \component: mlink
 *
 * \author: Ajay Kumar Sahoo ajaykumar.sahoo@in.bosch.com
 *
 * \copyright: (c) 2003 - 2013 ADIT Corporation
 *
 * \history
 * 0.1 Ajay Kumar Sahoo Initial version
***********************************************************************/

#ifndef _MLINK_WFD_DECODER_PLUGIN_H_
#define _MLINK_WFD_DECODER_PLUGIN_H_

#ifdef __cplusplus
extern "C"
{
#endif

#define VNC_USE_STDINT_H

#include "mlink_common.h"
#include "mlink_wfd_decoder_plugin_logging.h"
#include <vncwifidisplaydecoder.h>

#include <gst/gst.h>

struct VNCWiFiDisplayDecoderFactoryImpl
{
    //todo:log function pointer

    VNCWiFiDisplayDecoderFactoryContext decoderFactoryContext;
    VNCWiFiDisplayDecoderViewerContext decoderViewerContext;
    const VNCWiFiDisplayDecoderSupportingAPI *pDecoderSupportingAPI;
    size_t decoderSupportingAPISize;

    GMainLoop  *mainloop;
    GstElement *pipeline;
    GstElement *appsrc;
    struct wl_display* display;


};
struct VNCWiFiDisplayDecoderImpl
{
    //todo:log function pointer

    VNCWiFiDisplayDecoderContext decoderContext;
    struct VNCWiFiDisplayDecoderFactoryImpl *factoryInitInfo;
};

typedef void (*FirstVideoFrameRendered) (void *context);

typedef struct VNCWiFiDisplayDecoderViewerContextImpl
{
    FirstVideoFrameRendered firstvideoframerendered;
    void * context;
}VNCWiFiDisplayDecoderViewerContextImpl;


#ifdef __cplusplus
}
#endif

#endif /* _MLINK_WFD_DECODER_PLUGIN_H_ */
